﻿Param(
#Enter the name of one of the connection brokers
[Parameter(Mandatory=$true)][string]$ConnectionBrokerName,
#Specify the export folder
[Parameter(Mandatory=$false)][string]$ExportFolder = "C:\temp"
)
#Create empty array
$RemoteApps = @()
#Check which Connection Broker is active
$ActiveCBR = (Get-RDConnectionBrokerHighAvailability -ConnectionBroker $ConnectionBrokerName).ActiveManagementServer
#Get a list of servers and their roles (and convert the roles to string)
$ServersAndRoles = Get-RDServer -ConnectionBroker $ActiveCBR | Select-Object Server,@{label="Roles";expression={[string]$_.Roles}}
#Get Gateway configuration
$GatewayConfiguration = Get-RDDeploymentGatewayConfiguration -ConnectionBroker $ActiveCBR
#Get Session collections information
$SessionCollection = Get-RDSessionCollection -ConnectionBroker $ActiveCBR
#Get all RDS servers information (Collection name, Session Host name, NewConnectionsAllowed setting)
$AllRDSServers = Get-RDSessionCollection -ConnectionBroker $ActiveCBR | Select-Object -Property collectionname | ForEach-Object -Process { Get-RDSessionHost -ConnectionBroker $ActiveCBR -CollectionName $_.collectionname |  Sort-Object -Property SessionHost}
#Get Connection Broker HA information
$CBRHA = Get-RDConnectionBrokerHighAvailability
#Get a list of all differenct collections
$Collections = $AllRDSServers.CollectionName | Select-Object -Unique
#Loop through the collections
Foreach($Collection in $Collections)
{
    #Get a list of all remote apps on this collection
    $RemoteApps += Get-RDRemoteApp -CollectionName $Collection -ConnectionBroker $ActiveCBR | Select-Object CollectionName,Alias,DisplayName,FolderName,FilePath,FileVirtualPath,CommandLineSetting,RequiredCommandLine,IconPath,@{label="UserGroups";expression={[string]$_.UserGroups}},ShowInWebAccess
}
#Export all the gathered information on the RDS deployment
$ServersAndRoles | Sort-Object Roles,Server | Export-Csv "$ExportFolder\RDRServersAndRoles.csv" -Delimiter ";" -NoTypeInformation
$AllRDSServers | Export-Csv "$ExportFolder\RDRemoteSessionHostInfo.csv" -Delimiter ";" -NoTypeInformation
$RemoteApps | Export-Csv "$ExportFolder\RDRemoteAppInfo.csv" -Delimiter ";" -NoTypeInformation
$CBRHA | Select-Object ClientAccessName,DatabaseConnectionString,DatabaseFilePath | Export-Csv "$ExportFolder\RDCBRHA.csv" -Delimiter ";" -NoTypeInformation
$GatewayConfiguration | Export-Csv "$ExportFolder\RDGatewayConfiguration.csv" -Delimiter ";" -NoTypeInformation
$SessionCollection | Export-Csv "$ExportFolder\RDSessionCollection.csv" -Delimiter ";" -NoTypeInformation
