﻿$fileName = "MacroEnabledExcelFile" #without extenion
$folderName = "D:\temp"

$CurrentCulture = [System.Threading.Thread]::CurrentThread.CurrentCulture.Name
$dateTextMonth = Get-Date -Date (Get-Date).AddMonths(-1) -format MMMM
$dateTextYear = Get-Date -Date (Get-Date).AddMonths(-1) -format yyyy
$dateTextMonthString = $dateTextMonth.Substring(0,1).toUpper() + $dateTextMonth.Substring(1).ToLower()
[System.Threading.Thread]::CurrentThread.CurrentCulture = "en-US"
Add-Type -AssemblyName Microsoft.Office.Interop.Excel
$xlFixedFormat = [Microsoft.Office.Interop.Excel.XlFileFormat]::xlOpenXMLWorkbookMacroEnabled

$app = New-Object -comobject Excel.Application
$app.Visible = $True
$app.DisplayAlerts = $False
$wb = $app.Workbooks.Open("$folderName\$fileName.xlsm")
Start-Sleep 1

#enter a valid macro name here:
$app.Run("MacroNameToRun") 

$app.ActiveWorkbook.SaveAs("$folderName\$fileName $dateTextMonthString $dateTextYear.xlsm", $xlFixedFormat)
$app.Quit()

[System.Threading.Thread]::CurrentThread.CurrentCulture = $CurrentCulture
