﻿$WebUrl = "https://spelling.wordpress.com/2007/09/05/english-pronunciation/"
$Page = Invoke-WebRequest $WebUrl
$Pagetext = $Page.ParsedHtml.IHTMLDocument2_body.innerText.Substring($Page.ParsedHtml.IHTMLDocument2_body.innerText.IndexOf("If you can pronounce correctly"))
$Pagetext = $Pagetext.Substring(0,$Pagetext.IndexOf("é") + 1)
$Pagetext = $Pagetext.Split("`r`n")
$Poem = @()
Foreach($Line in $Pagetext)
{
    If($Line.Length -ne 0) { $Poem += $Line }
}

Add-Type -AssemblyName System.speech
$Speak = New-Object System.Speech.Synthesis.SpeechSynthesizer
$InstalledVoices = $Speak.GetInstalledVoices().VoiceInfo
For($x = 0; $x -lt $InstalledVoices.Count; $x++)
{
    Write-Host ($x+1) `t $InstalledVoices[$x].Name.Replace("Microsoft ","") `t $InstalledVoices[$x].Culture `t $InstalledVoices[$x].Gender
}
Write-host "Choose a voice (number): "
$Voice = Read-Host
cls
If(($Voice -gt 0) -and ($Voice -le $InstalledVoices.Count)) { $Speak.SelectVoice($InstalledVoices[$Voice - 1].Name) }
Else
{
    Write-Warning ("You selected a non-existing voice, using default voice: {0}" -f $InstalledVoices[0].Name) -WarningAction Continue
    $Speak.SelectVoice($InstalledVoices[0].Name)
}

For($Line = 0; $Line -lt $Poem.count; $Line++)
{
    Write-Host $Poem[$Line]
    If($Line -ne 0 -and $Line -ne $Poem.count -1)
    {
        $Speak.Speak($Poem[$Line])
    }
    Else { Start-Sleep -Seconds 5 }
}
