﻿Param([Parameter(Mandatory=$true)][string]$NppPath)

$InstallerFullName = $null
$InstallerName = $null

$Logtext = @()
$CurrentDate = (Get-Date -Format dd-MM-yyyy).ToString()
$CurrentTime = (Get-Date).ToShortTimeString()
$Logtext += "$CurrentDate $CurrentTime - Checking if the current Notepad++ installation is still up to date."

$Npp = Get-ChildItem "$NppPath\*.exe" | Sort-Object CreationTime -Descending | Select-Object -First 1
$InstallerFullName = $Npp.FullName
$InstallerName = "D:\Install\" + $Npp.Name
$Version = $npp.Name.Substring($npp.Name.IndexOf(".")+1)
$Version = $Version.Substring(0,$Version.IndexOf("I")-1)
[version]$NewVersion = $Version
$NppExe = Get-ChildItem 'C:\Program Files (x86)\Notepad++\notepad++.exe'
$VersionNumber = $NppExe.VersionInfo.FileMajorPart.ToString() + "." + $NppExe.VersionInfo.FileMinorPart.ToString() + "." + $NppExe.VersionInfo.FileBuildPart.ToString()
[version]$CurrentVersion = $VersionNumber
If($NewVersion -gt $CurrentVersion)
{
    $CurrentTime = (Get-Date).ToShortTimeString()
    $Logtext += "$CurrentDate $CurrentTime - Newer Notepad++ installation found in software library. Version $Version will be installed."
    Copy-Item $InstallerFullName "$InstallerName" -Force
    Start-Process "$InstallerName" "/S" -Wait
    Remove-Item "$InstallerName" -Force
}
Else
{
    $CurrentTime = (Get-Date).ToShortTimeString()
    $Logtext += "$CurrentDate $CurrentTime - The latest Notepad++ version is currently installed."
}
$CurrentTime = (Get-Date).ToShortTimeString()
$Logtext += "$CurrentDate $CurrentTime - Notepad++ updater script ran until the end."
[io.file]::WriteAllLines("$PSScriptRoot\NppUpdater.log",$Logtext)
