﻿Param([Parameter(Mandatory=$true)][string]$NppPath)

$WebUrl = "https://notepad-plus-plus.org/download"
$Client = new-object System.Net.WebClient 
$Page = Invoke-WebRequest $WebUrl
$Html = $Page.ParsedHtml
$Titles = $Html.title.Split(" ")
$Version = $Titles[1].Replace("v","")
$CurrentFiles = Get-ChildItem "$NppPath"
$Logtext = @()
$CurrentDate = (Get-Date -Format dd-MM-yyyy).ToString()
$CurrentTime = (Get-Date).ToShortTimeString()
$Logtext += "$CurrentDate $CurrentTime - Checking for new Notepad++ installations"

If ($CurrentFiles.Name -match $Version)
{
    #the latest file is already on disk, no need to do anything.
    $CurrentDate = (Get-Date -Format dd-MM-yyyy).ToString()
    $CurrentTime = (Get-Date).ToShortTimeString()
    $Logtext += "$CurrentDate $CurrentTime - No newer version available"
}
Else
{
    #get download link and download new file.
    $NppLink = $null
    $Links = $html.getElementsByTagName('li')
    Foreach($Link in $Links) { If(($Link.innerHTML -match "repository") -and ($Link.innerHTML -match ".exe")) { $NppLink = $Link.InnerHtml } }
    If($NppLink.Length -ne 0)
    {
        $Downloadlink = $NppLink.Substring($NppLink.IndexOf("/"))
        $Downloadlink = $Downloadlink.Substring(0,$Downloadlink.IndexOf('"'))
        $Downloadlink = "https://notepad-plus-plus.org" + $Downloadlink
        $Filename = $Downloadlink.Remove(0,$Downloadlink.LastIndexOf("/") + 1)
        $Client.DownloadFile($Downloadlink, "$NppPath\$Filename") 
        $CurrentDate = (Get-Date -Format dd-MM-yyyy).ToString()
        $CurrentTime = (Get-Date).ToShortTimeString()
        $Logtext += "$CurrentDate $CurrentTime - Downloaded version $Version."
        $Logtext += "$CurrentDate $CurrentTime - File saved to $NppPath\$Filename"
    }
}
$CurrentDate = (Get-Date -Format dd-MM-yyyy).ToString()
$CurrentTime = (Get-Date).ToShortTimeString()
$Logtext += "$CurrentDate $CurrentTime - Notepad++ download script ran until the end."
[io.file]::WriteAllLines("$PSScriptRoot\NppDownloader.log",$Logtext)
