﻿Param([Parameter(Mandatory=$true)][string]$MailRecipient)
#Check if the given mail addresses are in the correct mail address format (contains text before and after the [at]. After the [at] and the text, it expects a [dot] with a 2 to 4 letter TLD after that)
$TldUrl = "http://data.iana.org/TLD/tlds-alpha-by-domain.txt"
$TldFile = "$PSScriptRoot\tlds-alpha-by-domain.txt"
If((!(Test-Path $TldFile) -or ((Get-Date).Month -gt (Get-ChildItem $TldFile).LastWriteTime.Month)))
{
    $Client = new-object System.Net.WebClient
    $Client.DownloadFile($TldUrl, $TldFile) 
}

If(Test-Path $TldFile)
{
    $Tlds = [io.file]::ReadAllLines("$TldFile")
    $Regex = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,63}$"
    $MailAddresses = @()
    If($MailRecipient.Contains(";")) { $MailAddresses = $MailRecipient.Split(";") }
    Else { $MailAddresses = $MailRecipient }
    Foreach($MailAddress in $MailAddresses)
    {
        $Tld = $MailAddress.Substring($MailAddress.LastIndexOf(".") + 1)
        $Tld = $Tld.ToUpper()
        If($Tld -in $Tlds) { Write-Output "TLD exists for $MailAddress" }
        Else { Write-Error "$MailAddress is an invalid address, TLD doesn't exist" -Category ParserError -RecommendedAction "Correct the e-mail address." -CategoryReason "Incorrect TLD" -ErrorAction Continue }
        If($MailAddress -notmatch $Regex) { Write-Error -Message "Incorrect e-mail address entered. Please verify that $MailAddress has been entered correctly" -Category ParserError -RecommendedAction "Correct the e-mail address or use the -MailRecipient switch to specify one." -CategoryReason "Incorrect E-mail address" -ErrorAction Continue }
    }
}
