#Enter your Site ID here (6 digits):
$SiteID = "111111"
#Enter your API key here (32 characters):
$ApiKey = "APIKEYAPIKEYAPIKEYAPIKEYAPIKEYAPIKEYAP"
$Day = "DAY"
$15Min = "QUARTER_OF_AN_HOUR"
$CurrentDate = Get-Date -Format yyyy-MM-dd
$Date = Get-Date
$DataPeriodUrl = "https://monitoringapi.solaredge.com/site/$SiteID/dataPeriod?api_key=$ApiKey"
$OverviewUrl = "https://monitoringapi.solaredge.com/site/$SiteID/overview?api_key=$ApiKey"
$DetailsUrl = "https://monitoringapi.solaredge.com/site/$SiteID/details?api_key=$ApiKey"
$EnergyUrl = "https://monitoringapi.solaredge.com/site/$SiteID/energy?api_key=$ApiKey"

$SiteDetails = (Invoke-WebRequest $DetailsUrl).Content | ConvertFrom-Json
$SiteOverview = (Invoke-WebRequest $OverviewUrl).Content | ConvertFrom-Json

$LastUpdateTime = ($SiteOverview.overview.lastUpdateTime.Split(" "))[0]
$LastUpdateDateTime = Get-Date -Date $LastUpdateTime
If($LastUpdateTime -ne $CurrentDate)
{
    $DaysAgo = ($Date - $LastUpdateDateTime).Days
    SWitch($DaysAgo)
    {
        0 { Write-Output "The energy data on the monitoring portal is up to date, will start downloading data if necessary" }
        1 { Write-Warning "The energy data on the monitoring portal has not been updated for a day. This might have various reasons: `r`n - The update script is ran within the first 15 minutes of a new day, in that case it's usual behaviour.`r`n - There has been an interruption in the connection between the inverter and the monitoring portal.`r`n - No data has been received on the monitoring portal.`r`n Script will continue as usual." -WarningAction Continue }
        default { Write-Error "The installation has not been updated since $LastUpdateTime. This is $DaysAgo days ago. Script will continue, but it is advised to fix the error. This script will only download the data until the date of the last available data" -ErrorAction Continue }
    }
}

$DataPeriod = (Invoke-WebRequest $DataPeriodUrl).Content | ConvertFrom-Json
$StartDate = $DataPeriod.dataPeriod.startDate
$CurrentYear = $Date.Year
$StartYear = (Get-Date -Date $StartDate).Year
$LastMonth = $LastUpdateDateTime.Month

Function Get-EnergyDataRemoveNulls
{
    Param([Parameter(Mandatory=$true)][string]$Url,[Parameter(Mandatory=$true)][string]$FileName)
    $EnergyData = (Invoke-WebRequest "$Url").Content | ConvertFrom-Json
    #Get the daily values per month from the monitoring portal, we do not want empty cells (empty data happens when: the link between the inverter and the monitoring portal was down (ie: no internet connection))
    $Data = $EnergyData.energy.values | Where-Object value -ne $null | ConvertTo-Csv -Delimiter ";" -NoTypeInformation
    [io.file]::WriteAllLines("$PSScriptRoot\$FileName",$Data)
}

Function Get-EnergyDataReplaceNulls
{
    Param([Parameter(Mandatory=$true)][string]$Url,[Parameter(Mandatory=$true)][string]$FileName)
    $EnergyData = (Invoke-WebRequest "$Url").Content | ConvertFrom-Json
    $EnergyData.energy.values | ForEach-Object { If($_.value -eq $null) { $_.value = "0,0" }}
    $Data = $EnergyData.energy.values | ConvertTo-Csv -Delimiter ";" -NoTypeInformation
    If($Data -ne $null) { [io.file]::WriteAllLines("$PSScriptRoot\$FileName",$Data) }
}

For($Year = $StartYear; $Year -le $CurrentYear; $Year++)
{
    If($Year -eq $CurrentYear)
    {
        If($StartYear -eq $CurrentYear) { $Month = (Get-Date -Date $StartDate).Month }
        Else { $Month = 1 }
        
        If($LastMonth -le $LastUpdateDateTime.Month) { $LastMonth = $Date.Month }
        Else { $LastMonth = $LastUpdateDateTime.Month + 1 }
    }
    Else
    {
        If($Year -eq $StartYear) { $Month = (Get-Date -Date $StartDate).Month }
        Else { $Month = 1 }
        $LastMonth = 13
    }
    For($Month; $Month -lt $LastMonth; $Month++)
    {
        $LastDayOfTheMonth = ((Get-Date -Date "01-$Month-$Year" -Hour 0 -Minute 0 -Second 0).AddMonths(1).AddSeconds(-1)).Day
        $strMonth = "{0:0#}" -f $Month
        $FileName = "$Year" + $strMonth + " - " + $SiteDetails.details.name + $SiteID  + ".csv"
        $FileName15min = "$Year" + $strMonth + " - " + $SiteDetails.details.name + $SiteID  + "-15min.csv"
        If(!(Test-Path "$PSScriptRoot\$FileName"))
        {
            $Url = "$EnergyUrl&timeUnit=$Day&startDate=$Year-$strMonth-01&endDate=$Year-$strMonth-$LastDayOfTheMonth"
            Get-EnergyDataRemoveNulls -Url "$Url" -FileName $FileName
        }
        Else { Write-Output "File $FileName already exists. Script will not download this data again" }
        If(!(Test-Path "$PSScriptRoot\$FileName15min"))
        {
            $Url = "$EnergyUrl&timeUnit=$15Min&startDate=$Year-$strMonth-01&endDate=$Year-$strMonth-$LastDayOfTheMonth"
            Get-EnergyDataReplaceNulls -Url "$Url" -FileName $FileName15min
        }
        Else { Write-Output "File $FileName15min already exists. Script will not download this data again" }
    }
    If(($Year -lt $CurrentYear) -and ($Year -le $LastUpdateDateTime.Year))
    {
        $Url = "$EnergyUrl&timeUnit=$Day&startDate=$Year-01-01&endDate=$Year-12-31"
        $FileName = "$Year - " + $SiteDetails.details.name + $SiteID  + ".csv"
        If(!(Test-Path "$PSScriptRoot\$FileName"))
        {
            Get-EnergyDataRemoveNulls -Url "$Url" -FileName $FileName
        }
        Else { Write-Output "File $FileName already exists. Script will not download this data again" }
    }
}
